data "google_compute_instance_group" "checker_instance_group" {
  name = google_compute_instance_group_manager.checker_instance_group_manager.name
  zone = var.zone

  depends_on = [time_sleep.wait_for_health_check]
}

data "google_compute_instance" "checker_instance" {
  count     = var.disable_instances_output ? 0 : local.nodes_count
  self_link = tolist(local.created_instances)[count.index]

  lifecycle {
    precondition {
      condition     = var.disable_instances_output || length(local.created_instances) == local.nodes_count
      error_message = "Only ${length(local.created_instances)}/${local.nodes_count} instances where created, please retry again later, or run with 'TF_VAR_disable_instances_output=true' to ignore."
    }
  }
}

data "google_compute_instance_group_manager" "checker_instance_group_manager" {
  self_link = data.google_compute_instance_group.checker_instance_group.self_link

  lifecycle {
    postcondition {
      condition     = alltrue(self.status[*].is_stable)
      error_message = <<-EOT
      Health check did not become stable after 5 minutes, this usually means that the firewall was not configured properly for health checks.
      The voc cluster needs to have a firewall rule that allows traffic from the health check IPs ranges (130.211.0.0/22, 35.191.0.0/16) to port 22 on the instances.
      This is usually done by setting such a rule for the default voc '${local.default_health_check_tag}' network tag. but can also be done by setting another network tag
      and passing that tag to the checker (and to the voc cluster creation script later on), as one of the tags in the optional "network_tags" variable.
      EOT
    }
  }
}