// internal only variables
variable "disable_instances_output" {
  type    = bool
  default = false
}

variable "machine_type" {
  type    = string
  default = "e2-medium"
}

variable "image" {
  type    = string
  default = "rocky-linux-9-optimized-gcp-v20240815"
}

variable "ssh_public_key" {
  type        = string
  description = "A public SSH key that will be used for user centos, usually not needed"
  default     = ""
}

variable "name" {
  type        = string
  description = "A unique name for the checker, if not provided a random uuid based name will be generated"
  default     = ""
  validation {
    // Current length limit is 32
    condition     = var.name == "" || try(regex("^(?:[a-z0-9](?:[-a-z0-9]{0,30}[a-z0-9])?)$", var.name), null) != null
    error_message = <<-EOT
    Variable "name" Must match the regex: '$^(?:[a-z](?:[-a-z0-9]{0,30}[a-z0-9])?)$'
    Begin with a lower case letter
    Include lower case letters, number, and hyphens ("-")
    End with a lower case letter or number
    Contain between 1 and 32 characters
    EOT
  }
}
