locals {
  script_name = "checker"
  name        = var.name != "" ? var.name : replace(uuid(), "-", "")
  full_name   = "${local.script_name}-${local.name}"
  nodes_count = 1

  health_check_port = "22"

  default_health_check_tag = "voc-health-check"
  voc_network_tags         = [local.default_health_check_tag, "voc-internal"]

  region = regex("(.*)-[a-z]+", var.zone)[0]

  centos_public_key = var.ssh_public_key == "" ? null : "centos:${var.ssh_public_key}"

  created_instances = data.google_compute_instance_group.checker_instance_group.instances

  instance = var.disable_instances_output ? null : data.google_compute_instance.checker_instance[0]

  private_ip    = var.disable_instances_output ? null : local.instance.network_interface[0].network_ip
  instance_name = var.disable_instances_output ? null : element(split("/", local.instance.self_link), length(split("/", local.instance.self_link)) - 1)
}
