// required variables
variable "zone" {
  type        = string
  description = "What is the GCP zone where the machines will be created"
}

variable "subnetwork" {
  type        = string
  description = "In which subnetwork to create the machine"
}

variable "project_id" {
  type        = string
  description = "The GCP project id to create the machines at"
}

// variables with defaults
variable "onprem_ip" {
  type        = string
  default     = ""
  description = "OnPrem IP to check connectivity to, leave empty to disable check"
}

variable "network_tags" {
  type        = list(string)
  default     = []
  description = "A list of network tags to attach to a machine - same variable as you would use on voc, needed if your health check firewall rules are based on network tags other than voc-health-check and voc-internal"
}
